#include <pspsdk.h>
#include <pspkernel.h>
#ifndef __UMDISODUMPER_H__
#define __UMDISODUMPER_H__

#include <stdio.h>
#include <string.h>

#include "umddumper.h"


class UMDIsoDumper : public UMDDumper
{

protected:

	void	*dumpIoOpen(const char *file);
	int		dumpIoWrite(void *fd, u8 *sectors, int nsectors, int *realWritten);
	int		dumpIoClose(void *fd);

public:

	UMDIsoDumper(char *basefilename) : UMDDumper(basefilename)
	{
		snprintf(isofile, 256, "%s%s", basefilename, ".iso");
	}

	~UMDIsoDumper()
	{
	}
};

#endif
