#include "umdisodumper.h"


void *UMDIsoDumper::dumpIoOpen(const char *file)
{
	SceUID fd = sceIoOpen(file, PSP_O_WRONLY | PSP_O_CREAT, 0777);

	return (fd < 0) ? (void *)-1 : (void *)fd;
}

int	UMDIsoDumper::dumpIoWrite(void *fd, u8 *sectors, int nsectors, int *realWritten)
{
	*realWritten = sceIoWrite((SceUID)fd, sectors, nsectors * UMD_SECTOR_SIZE);
	return *realWritten / UMD_SECTOR_SIZE;
}

int	UMDIsoDumper::dumpIoClose(void *fd)
{
	return sceIoClose((SceUID)fd);
}

