#ifndef __UMDGZIPDUMPER_H__
#define __UMDGZIODUMPER_H__


#include <pspsdk.h>
#include <pspkernel.h>

#include <stdio.h>
#include <string.h>

#include "umddumper.h"

class UMDGzipDumper : public UMDDumper
{

private:

	int	complevel;

protected:

	void	*dumpIoOpen(const char *file);
	int		dumpIoWrite(void *fd, u8 *sectors, int nsectors, int *realWritten);
	int		dumpIoClose(void *fd);

public:

	UMDGzipDumper(char *basefilename, int complevel) : UMDDumper(basefilename)
	{
		this->complevel = complevel;
		snprintf(isofile, 256, "%s%s", basefilename, ".gz");
	}

	~UMDGzipDumper()
	{
	}

	int getCompressionLevel()
	{
		return complevel;
	}

	void setCompressionLevel(int complevel)
	{
		this->complevel = complevel;
	}
};

#endif







