#include <zlib.h>
#include "umdgzipdumper.h"


void *UMDGzipDumper::dumpIoOpen(const char *file)
{
	char mode[4];
	gzFile fd;

	strcpy(mode, "wb");
	mode[3] = '0' + this->complevel;
	mode[4] = 0;

	fd = gzopen(file, mode);

	return (fd == NULL) ? (void *)-1 : (void *)fd;
}

int	UMDGzipDumper::dumpIoWrite(void *fd, u8 *sectors, int nsectors, int *realWritten)
{
	// This is a bug. This is not the real numbers of bytes written, 
	// but the decompressed ones.
	// This is the cause because split is not currently supported when 
	// dumping to gzip
	*realWritten = gzwrite((gzFile)fd, sectors, nsectors*UMD_SECTOR_SIZE);
	
	return *realWritten / UMD_SECTOR_SIZE;
}

int	UMDGzipDumper::dumpIoClose(void *fd)
{
	return gzclose((gzFile)fd);
}

