#ifndef __UMDDUMPER_H__
#define __UMDDUMPER_H__


#include <pspsdk.h>
#include <pspkernel.h>
#include <string.h>


#define UMD_SECTOR_SIZE		2048
#define MAX_UMD_SIZE		0x7FFFFFFF
#define	SECTORS_PER_WRITE	128
#define PERCENTAGE_REFRESH_SPEED	16

enum DumpError
{
	DUMP_ERROR_SUCCESS = 1,
	DUMP_ERROR_ALLDATA_READ = 0,
	DUMP_ERROR_CANNOT_READ_DISC = -1,
	DUMP_ERROR_CANNOT_WRITE_FILE = -2,
	DUMP_ERROR_ABORT = -3,
};




class UMDDumper
{

private:
	char	basefilename[256];
	int		partsize;
	int		discpointer;
	int		discEOF;
	int		abort;
	
	void	(* progress)(int, int);

protected:

	char	isofile[256];
	int		ipart;

	virtual	void	*dumpIoOpen(const char *file)=0;
	virtual	int		dumpIoWrite(void *fd, u8 *sectors, int nsectors, int *realWritten)=0;
	virtual	int		dumpIoClose(void *fd)=0;

		
public:

	UMDDumper(char *basefilename)
	{
		strncpy(this->basefilename, basefilename ? basefilename : "", 256);
		
		this->partsize = 0;
		this->discpointer = 0;
		this->discEOF = 0;
		this->abort = 0;
		this->ipart = 0;
		this->progress = NULL;
	}
	
	virtual	~UMDDumper()
	{
	}

	char *getBaseFilename()
	{
		return basefilename;
	}

	int getPartSize()
	{
		return partsize;
	}

	void setPartSize(int partsize)
	{
		if (partsize == 0)
			this->partsize = MAX_UMD_SIZE;
		else
			this->partsize = partsize;
	}

	void setProgressFunc(void	(* progress)(int, int))
	{
		this->progress = progress;
	}

	int	dumpNextPart();

	void abortDump()
	{
		this->abort = 1;
	}

	static int	getUMDSizeSectors();

	static int getUMDSizeBytes()
	{
		return getUMDSizeSectors() * UMD_SECTOR_SIZE;
	}
};

#endif

