#include "umddumper.h"

#include <stdio.h>

static u8 discbuffer[SECTORS_PER_WRITE*UMD_SECTOR_SIZE];

int UMDDumper::getUMDSizeSectors()
{
	SceUID umd;
	int size;

	umd = sceIoOpen("umd0:", PSP_O_RDONLY, 0777);
	
	if (umd < 0)
		return DUMP_ERROR_CANNOT_READ_DISC;

	size = sceIoLseek(umd, 0, PSP_SEEK_END);

	// round to 8192
	if ((size % (8192 / UMD_SECTOR_SIZE)) != 0)
		size += ((8192 / UMD_SECTOR_SIZE) - (size % (8192 / UMD_SECTOR_SIZE)));

	sceIoClose(umd);

	return size;
}

int UMDDumper::dumpNextPart()
{
	SceUID umd;
	void  *iso;

	int nsectors;
	int sectorswritten, totalsectorswritten;
	int realwritten, totalwritten;
	int read, res;
	char file[256];

	if (this->discEOF)
		return DUMP_ERROR_ALLDATA_READ;

	nsectors = this->getUMDSizeSectors();

	umd = sceIoOpen("umd0:", PSP_O_RDONLY, 0777);

	if (umd < 0)
		return DUMP_ERROR_CANNOT_READ_DISC;

	strcpy(file, isofile);

	if (this->partsize != MAX_UMD_SIZE)
	{	
		snprintf(file+strlen(file), 256, ".%04d", this->ipart);
	}
	
	iso = this->dumpIoOpen(file);

	if (iso == (void *)-1)
	{
		sceIoClose(umd);
		return DUMP_ERROR_CANNOT_WRITE_FILE;
	}

	sceIoLseek(umd, this->discpointer, PSP_SEEK_SET);

	sectorswritten = 0;
	totalsectorswritten = 0;
	realwritten = 0;
	totalwritten = 0;
	res = DUMP_ERROR_SUCCESS;

	if (this->progress)
		this->progress(totalsectorswritten + this->discpointer, nsectors);

	while (1)
	{
		read = sceIoRead(umd, discbuffer, SECTORS_PER_WRITE);

		if (read < 0)
		{
			res = DUMP_ERROR_CANNOT_READ_DISC;
			break;
		}

		if (read < SECTORS_PER_WRITE)
		{
			// Allign to 8192
			if ((read % (8192 / UMD_SECTOR_SIZE)) != 0)
			{
				int fillsectors = ((8192 / UMD_SECTOR_SIZE) - (read % (8192 / UMD_SECTOR_SIZE)));
				
				memset(discbuffer+(read * UMD_SECTOR_SIZE), 0, fillsectors * UMD_SECTOR_SIZE);
				read += fillsectors;
			}

			discEOF = 1;
			res = DUMP_ERROR_ALLDATA_READ;			
		}

		sectorswritten = dumpIoWrite(iso, discbuffer, read, &realwritten);

		if (sectorswritten != read)
		{
			res = DUMP_ERROR_CANNOT_WRITE_FILE;
			break;
		}
		
		totalsectorswritten += sectorswritten;
		totalwritten += realwritten;		

		if (this->abort)
		{
			res = DUMP_ERROR_ABORT;
			break;
		}

		if (this->discEOF)
			break;

		if (totalwritten >= partsize)
			break;

		if ((totalsectorswritten % (SECTORS_PER_WRITE * PERCENTAGE_REFRESH_SPEED)) == 0)
		{
			if (this->progress)
				this->progress(totalsectorswritten + discpointer, nsectors);
		}
	} 

	if (res >= 0)
	{
		if (this->progress)
			this->progress(totalsectorswritten + discpointer, nsectors);
		
		this->discpointer = sceIoLseek(umd, 0, PSP_SEEK_CUR);
	}

	sceIoClose(umd);
	dumpIoClose(iso);
	
	this->ipart++;

	return res;
}
