#ifndef __UMDDAXDUMPER_H__
#define __UMDDAXDUMPER_H__

#include <pspsdk.h>
#include <pspkernel.h>

#include <stdio.h>
#include <string.h>

#include "umddumper.h"

#define DAXFILE_SIGNATURE 0x00584144 /* "DAX\0" */

#define DAX_FRAME_SIZE	8192

#define MAX_DAX_FRAMES	262144

typedef struct
{
	u32 signature; 
	u32 decompsize; /* Size of original non-compressed file */
	u32 version;   /* DAX format version */
	u32 nNCareas; /* Number of non-compressed areas. */
	u32 reserved[4]; /* Reserved for future use. It must be zero */
} DAXHeader;


class UMDDaxDumper : public UMDDumper
{

private:

	int	complevel;
	int nframes, iframe, daxpointer;
	u32 offsets[MAX_DAX_FRAMES];
	u16 lengths[MAX_DAX_FRAMES];
	u8 daxbuffer[(SECTORS_PER_WRITE*UMD_SECTOR_SIZE)+(SECTORS_PER_WRITE*1024)];	

	void	writeHeader(SceUID fd);

protected:

	void	*dumpIoOpen(const char *file);
	int		dumpIoWrite(void *fd, u8 *sectors, int nsectors, int *realWritten);
	int		dumpIoClose(void *fd);

public:

	UMDDaxDumper(char *basefilename, int complevel) : UMDDumper(basefilename)
	{
		this->complevel = complevel;
		snprintf(this->isofile, 256, "%s%s", basefilename, ".dax");

		this->ipart = 1;
		
		this->nframes = this->getUMDSizeBytes() / DAX_FRAME_SIZE;
		this->iframe = 0;
	
		memset(this->offsets, 0, this->nframes*4);
		memset(this->lengths, 0, this->nframes*2);

		daxpointer = sizeof(DAXHeader) + (nframes * 6);
	}

	~UMDDaxDumper();
	

	int getCompressionLevel()
	{
		return complevel;
	}

	void setCompressionLevel(int complevel)
	{
		this->complevel = complevel;
	}
};

#endif
