#include <zlib.h>
#include "umddaxdumper.h"


void UMDDaxDumper::writeHeader(SceUID fd)
{
	DAXHeader header;

	memset(&header, 0, sizeof(header));
	header.signature = DAXFILE_SIGNATURE;
	header.decompsize = this->nframes * DAX_FRAME_SIZE;
	header.version = 0;

	sceIoWrite((SceUID)fd, &header, sizeof(DAXHeader));
	sceIoWrite((SceUID)fd, this->offsets, this->nframes * 4);
	sceIoWrite((SceUID)fd, this->lengths, this->nframes * 2);
}

void *UMDDaxDumper::dumpIoOpen(const char *file)
{
	SceUID fd = sceIoOpen(file, PSP_O_WRONLY | PSP_O_CREAT, 0777);

	if (this->getPartSize() == MAX_UMD_SIZE) /* Only one file */
	{
		this->writeHeader(fd);
	}

	return (fd < 0) ? (void *)-1 : (void *)fd;
}

int	UMDDaxDumper::dumpIoWrite(void *fd, u8 *sectors, int nsectors, int *realWritten)
{
	int i, n = (nsectors * UMD_SECTOR_SIZE) / DAX_FRAME_SIZE;
	int csizetotal = 0;
	u8 *buffer = this->daxbuffer;

	for (i = 0; i < n; i++)
	{
		unsigned long csize;

		csize = DAX_FRAME_SIZE+1024;
		
		if (compress2(buffer, &csize, sectors+(i*DAX_FRAME_SIZE), DAX_FRAME_SIZE, this->complevel) != Z_OK)
			return -1;

		this->offsets[this->iframe] = this->daxpointer;
		this->lengths[this->iframe] = csize;
		
		this->daxpointer += csize;
		csizetotal += csize;
		buffer += csize;
		this->iframe++;
	}

	*realWritten = sceIoWrite((SceUID)fd, this->daxbuffer, csizetotal);

	if (*realWritten != csizetotal)
		return -1;

	return nsectors;
}

int	UMDDaxDumper::dumpIoClose(void *fd)
{
	if (this->getPartSize() == MAX_UMD_SIZE) /* Only one file */
	{
		sceIoLseek32((SceUID)fd, 0, PSP_SEEK_SET);
		writeHeader((SceUID)fd);
	}
	
	return sceIoClose((SceUID)fd);
}

UMDDaxDumper::~UMDDaxDumper()
{
	if (this->getPartSize() != MAX_UMD_SIZE)
	{
		SceUID dax;		

		char file[256];

		sprintf(file, "%s.0000", this->isofile);

		dax = sceIoOpen(file, PSP_O_WRONLY | PSP_O_CREAT, 0777);

		if (dax >= 0)
		{
			this->writeHeader(dax);
			sceIoClose(dax);
		}
	}
}


