#include <pspsdk.h>
#include <pspkernel.h>
#include <pspdebug.h>
#include <pspdisplay.h>
#include <pspiofilemgr.h>
#include <pspctrl.h>

#include <stdio.h>
#include <string.h>

#include <umedax.h>


PSP_MODULE_INFO("Little Loader", 0x1000, 1, 1);
PSP_MAIN_THREAD_ATTR(0);

#define CORE_FILE		"ms0:/UMDEMULATOR/FUSEDCORE.BIN"
#define ISOS_PATH		"ms0:/ISO/"
#define CONF_PATH		"ms0:/UMDEMULATOR/CONF/"
#define MPH_EBOOT		"ms0:/MPHGameLoader/EBOOT.PBP"
#define RUNUMD_EBOOT	"ms0:/UMDEMULATOR/RUNUMD.PBP"
#define BOOT_BIN		"disc0:/PSP_GAME/SYSDIR/BOOT.BIN"

#define printf pspDebugScreenPrintf

char isoslist[64][128];

int listFiles(char *path)
{
	SceUID dfd; 
	int i = 0;	
	
	dfd = sceIoDopen(path);

	if (dfd >= 0)
	{
		SceIoDirent dir;

		memset(&dir, 0, sizeof(SceIoDirent));

		while(sceIoDread(dfd, &dir) > 0)
		{
			if(!(dir.d_stat.st_attr & FIO_SO_IFDIR))
			{
				strcpy(isoslist[i], dir.d_name);
				i++;				
			}
		}

		sceIoDclose(dfd);
	}
	
	return i;
}

void printIso(int i, int highlight)
{
	pspDebugScreenSetXY(0, i+2);
	pspDebugScreenSetTextColor((highlight) ? 0x000000FF : 0x00FFFFFF);
	printf(isoslist[i]);
}

int sceKernelLoadExec_User(const char *file, struct SceKernelLoadExecParam *param)
{
	// We create this function to ensure that the sceKernelLoadExec
	// function is called through a syscall, and not from a direct
	// jump, which cannot be done in an user thread.
	asm("syscall 0x20e9\n");

	return 0; // -> just to avoid compiler warning
}

int thread_start(SceSize args, void *argp)
{
	struct SceKernelLoadExecParam param;

	memset(&param, 0, sizeof(param));
	param.size = sizeof(param);
	param.args = strlen(argp) + 1;
	param.argp = argp;

	sceKernelLoadExec_User(argp, &param);

	return 0;
}

void doDirectLoadExec()
{
	SceUID thid;

	/*
	 * Note: the sceKernelLoadExec fails (in 1.50) in kernel mode when
	 * trying to execute a file from the disc(real disc or not), it 
	 * complains about device not found even if we mount the disc.
	 * That's why we call the sceKernelLoadExec function in user mode.
	 * (here it's not necessary to mount the disc)
	*/
	thid = sceKernelCreateThread("loadexec_user", thread_start, 8,
		0x00010000, PSP_THREAD_ATTR_USER, NULL);

	if (thid >= 0)
	{		
		sceKernelStartThread(thid, strlen(BOOT_BIN)+1, BOOT_BIN);	
	}	
}

void doMPHGLExec()
{
	char *s;
	struct SceKernelLoadExecParam param;

	s = MPH_EBOOT;

	memset(&param, 0, sizeof(param));
	param.size = sizeof(param);
	param.args = strlen(s) + 1;
	param.argp = s;

	sceKernelLoadExec(s, &param);	
	sceKernelExitDeleteThread(0);	
}

void patchCoreForRUNUMD()
{
	/* Nop redirection of sceIoOpen */
	/* 
	 * sw $t2, 0($t1) -> nop 
	 * sw $t3, 4($t1) -> nop
	*/ 
	_sw(0, 0x883e00b0);
	_sw(0, 0x883e00b4);

	/* Nop redirection of sceIoOpenAsync */
	/* 
	 * sw $t2, 0($t1) -> nop 
	 * sw $t3, 4($t1) -> nop
	*/ 
	_sw(0, 0x883e00c8);
	_sw(0, 0x883e00cc);
}

void doRUNUMDExec()
{
	char *s;
	struct SceKernelLoadExecParam param;

	patchCoreForRUNUMD();

	s = RUNUMD_EBOOT;

	memset(&param, 0, sizeof(param));
	param.size = sizeof(param);
	param.args = strlen(s) + 1;
	param.argp = s;

	sceKernelLoadExec(s, &param);	
	sceKernelExitDeleteThread(0);
}

int main()
{
	SceCtrlData pad;
	int i, n, keyprocessed;

	pspDebugScreenInit();
	pspDebugScreenClear();

	printf("Little Loader Sample (by Dark_AleX)\n\n");

	pspDebugScreenSetXY(0, 24);
	printf("Press X to load iso with the Direct Load - LoadExec method.\n"
		   "Press L to Load iso with MPGH - LoadExec method\n"
		   "Press R to Load iso with RUNUMD - LoadExex mrthod\n"
		   "Press triangle to quit emulation and exit.");

	n = listFiles(ISOS_PATH);

	for (i = 0; i < n; i++)
	{
		printIso(i, (i == 0));
	}
	
	sceCtrlSetSamplingCycle(0);
	sceCtrlSetSamplingMode(PSP_CTRL_MODE_DIGITAL);

	i = 0;
	
	while(1)
	{
		char configfile[256], iso[256];
		UMEDAXConfig config;

		sceCtrlReadBufferPositive(&pad, 1);
		keyprocessed = 0;
		
		if (pad.Buttons & PSP_CTRL_UP)
		{
			if (i != 0)
			{
				printIso(i, 0);
				printIso(--i, 1);
			}

			keyprocessed = 1;
		}

		else if (pad.Buttons & PSP_CTRL_DOWN)
		{
			if (i != (n-1))
			{
				printIso(i, 0);
				printIso(++i, 1);
			}

			keyprocessed = 1;
		}

		else if (pad.Buttons & PSP_CTRL_CROSS)
		{
			sprintf(configfile, "%s%s.dat", CONF_PATH, isoslist[i]);
			sprintf(iso, "%s%s", ISOS_PATH, isoslist[i]);

			readConfig(configfile, &config);
			config.daxcoreconfig.emulationmode = DAX_EMUMODE_DIRECTLOADEXEC;
			writeConfig(configfile, &config);

			installUMEDAXCore(CORE_FILE, iso, &config.coreconfig, &config.daxcoreconfig);
			sceKernelDelayThread(50000);

			doDirectLoadExec();
		}

		else if (pad.Buttons & PSP_CTRL_LTRIGGER)
		{
			sprintf(configfile, "%s%s.dat", CONF_PATH, isoslist[i]);
			sprintf(iso, "%s%s", ISOS_PATH, isoslist[i]);

			readConfig(configfile, &config);
			config.daxcoreconfig.emulationmode = DAX_EMUMODE_MPHGLOADEXEC;
			writeConfig(configfile, &config);

			installUMEDAXCore(CORE_FILE, iso, &config.coreconfig, &config.daxcoreconfig);
			sceKernelDelayThread(50000);

			doMPHGLExec();
		}

		else if (pad.Buttons & PSP_CTRL_RTRIGGER)
		{
			sprintf(configfile, "%s%s.dat", CONF_PATH, isoslist[i]);
			sprintf(iso, "%s%s", ISOS_PATH, isoslist[i]);

			readConfig(configfile, &config);
			config.daxcoreconfig.emulationmode = DAX_EMUMODE_RUNUMDLOADEXEC;
			writeConfig(configfile, &config);

			installUMEDAXCore(CORE_FILE, iso, &config.coreconfig, &config.daxcoreconfig);
			sceKernelDelayThread(50000);

			doRUNUMDExec();
		}

		else if (pad.Buttons & PSP_CTRL_TRIANGLE)
		{
			uninstallUMEDAXCore();
			sceKernelExitGame();
		}

		
		sceKernelDelayThread(keyprocessed ? 200000 : 50000);
	}

	return 0;
}

